<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('common/auth/login');
})->name('login');
Route::POST('/authenticate', 'App\Http\Controllers\Auth\LoginController@authenticate')->name('authenticate');
Route::POST('/logout', 'App\Http\Controllers\Auth\LoginController@logout')->name('logout')->middleware('auth');

Route::get('home', 'App\Http\Controllers\HomeController@index')->name('home')->middleware('auth');

Route::resource('example', 'App\Http\Controllers\ExampleController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');

Route::resource('car', 'App\Http\Controllers\CarController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');

Route::resource('user', 'App\Http\Controllers\UserController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');

Route::resource('item', 'App\Http\Controllers\ItemController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');

Route::resource('type', 'App\Http\Controllers\TypeController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');

Route::resource('billing', 'App\Http\Controllers\BillingController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');

Route::resource('partner', 'App\Http\Controllers\PartnerController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');

Route::resource('report', 'App\Http\Controllers\ReportController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy', 'show'
])->middleware('auth');
Route::resource('report.waypoint', 'App\Http\Controllers\ReportWaypointController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');
Route::resource('report.rest', 'App\Http\Controllers\ReportRestController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');
Route::resource('report.partner', 'App\Http\Controllers\ReportPartnerController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');

Route::get('total/report/quantity', 'App\Http\Controllers\TotalReportController@quantity')->name('total.report.quantity')->middleware('auth');
Route::get('total/report/oil', 'App\Http\Controllers\TotalReportController@oil')->name('total.report.oil')->middleware('auth');
Route::get('total/report/highway', 'App\Http\Controllers\TotalReportController@highway')->name('total.report.highway')->middleware('auth');

// ◆◆◆検査対応：元の処理◆◆◆
// Route::get('csv/billing', 'App\Http\Controllers\CsvBillingController@index')->name('csv.billing')->middleware('auth');
// Route::get('csv/billing/download', 'App\Http\Controllers\CsvBillingController@download')->name('csv.billing.download')->middleware('auth');
// ◆◆◆検査対応：ココから◆◆◆
// Route::get('pdf/billing', 'App\Http\Controllers\CsvBillingController@index')->name('csv.billing')->middleware('auth');
// Route::get('pdf/billing/download', 'App\Http\Controllers\CsvBillingController@download')->name('csv.billing.download')->middleware('auth');
// ◆◆◆検査対応：ココまで◆◆◆

Route::get('work', 'App\Http\Controllers\WorkController@index')->name('work.index')->middleware('auth');
Route::get('emergency', 'App\Http\Controllers\WorkController@index')->name('emergency.index')->middleware('auth');
Route::resource('work.waypoint', 'App\Http\Controllers\ReportWaypointController')->only([
  'index', 'create', 'store', 'edit', 'update', 'destroy'
])->middleware('auth');
Route::get('work/{reportId}/waypoint/emergency', 'App\Http\Controllers\ReportWaypointController@emergency')->name('work.emergency')->middleware('auth');

// ◆◆◆検査対応：ココから◆◆◆
// Route::resource('emergency', 'App\Http\Controllers\EmergencyController')->only([
//   'index', 'create', 'store'
// ])->middleware('auth');
// Route::get('emergency/get/report', 'App\Http\Controllers\EmergencyController@getReportId')->middleware('auth');
// Route::get('home/work', function () {
//   return view('_menu/work');
// });
// Route::get('view/emergency/details/{reportId}', 'App\Http\Controllers\EmergencyController@details')->name('view.emergency.details');
// ◆◆◆検査対応：ココまで◆◆◆

// PDF出力
Route::get('pdf/billing', 'App\Http\Controllers\PdfBillingController@index')->name('pdf.billing')->middleware('auth');
Route::get('pdf/billing/{id}/details', 'App\Http\Controllers\PdfBillingController@details')->name('pdf.billing.details')->middleware('auth');
Route::get('pdf/billing/output', 'App\Http\Controllers\PdfBillingController@output')->name('pdf.billing.output')->middleware('auth');

// 緊急配車メール
Route::get('view/emergency/details/{reportId}', 'App\Http\Controllers\EmergencyController@details')->name('view.emergency.details');
