<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo app('translator')->get('system.title.home'); ?></h1>
    </div>
  </div>

<?php if($reports->count() === 0): ?>
  <div class="row">
    <div class="col">
      <div class="alert alert-dismissible alert-info">
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        <?php echo e(Auth::user()->name); ?>さんの今日（始業時間<?php echo e($work_start_time); ?>）の<?php echo app('translator')->get('db.reports'); ?>はまだ作成されていません。
      </div>
    </div>
  </div>
<?php endif; ?>

<?php if($reports->count() > 0): ?>
  <div class="row">
    <?php $__currentLoopData = $reports->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="col-12 col-md-6">
      <div class="card border-primary mb-3">
        <div class="card-header"><?php echo e(date('Y年n月j日', strtotime($report->start_at))); ?>の<?php echo app('translator')->get('db.reports'); ?><a href="/report/<?php echo e($report->id); ?>/edit" class="btn btn-xs btn-success fw-bold ms-2"><span class="bi bi-pencil-fill"></span></a></div>
        <div class="card-body">
          <div class="container-fluid p-0 m-0">
            <div class="row">
              <div class="col-12 col-md-6">
                <p><span class="bi bi-truck me-2"></span><?php echo app('translator')->get('db.report.car_id'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e($report->car->number); ?>（<?php echo app('translator')->get('db.report.alcohol_check-'.intval($report->alcohol_check)); ?>）</strong></p>
              </div>
              <div class="col-12 col-md-6">
                <p><span class="bi bi-sun me-2"></span><?php echo app('translator')->get('db.report.start'); ?>&nbsp;:&nbsp;<br class="d-sm-none" />
                  <?php if(empty($report->start_at) || empty($report->start_point) || empty($report->start_meter)): ?>
                  <a href="/report/<?php echo e($report->id); ?>/edit?hash=report_start" class="text-warning fw-bold">
                    <span class="text-warning"><strong>＜未入力があります＞</strong></span>
                  </a>
                  <?php else: ?>
                  <strong><?php echo e(date('G時i分', strtotime($report->start_at))); ?>（<?php echo e($report->start_point); ?>）</strong>
                  <?php endif; ?>
                </p>
              </div>
              <div class="col-12 col-md-6">
                <p><span class="bi bi-moon-stars me-2"></span><?php echo app('translator')->get('db.report.end'); ?>&nbsp;:&nbsp;<br class="d-sm-none" />
                  <?php if(empty($report->end_at) || empty($report->end_point) || empty($report->end_meter)): ?>
                  <a href="/report/<?php echo e($report->id); ?>/edit?hash=report_end" class="text-warning fw-bold">
                    <span class="text-warning"><strong>＜乗務中＞</strong></span>
                  </a>
                  <?php else: ?>
                  <strong><?php if(date('Ymd', strtotime($report->start_at)) !== date('Ymd', strtotime($report->end_at))): ?>(<?php echo e(date('j日', strtotime($report->end_at))); ?>)&nbsp;<?php endif; ?><?php echo e(date('G時i分', strtotime($report->end_at))); ?>（<?php echo e($report->end_point); ?>）</strong>
                  <?php endif; ?>
                </p>
              </div>
              <?php if($report->rests->count() > 0): ?>
                <?php $__currentLoopData = $report->rests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_rest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if(empty($report_rest->end_at)): ?>
                  <div class="col-12 col-md-6">
                    <p><span class="bi bi-tree me-2"></span><?php echo app('translator')->get('db.report_rests_short'); ?>&nbsp;:&nbsp;<br class="d-sm-none" />
                      <a href="/report/<?php echo e($report->id); ?>/rest/<?php echo e($report_rest->id); ?>/edit" class="text-warning fw-bold">
                        <strong><?php echo e(date('G時i分', strtotime($report_rest->start_at))); ?>&nbsp;～＜休憩中＞</strong>
                      </a>
                    </p>
                  </div>
                  <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-speedometer me-2"></span><?php echo app('translator')->get('db.report.start_meter'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->start_meter)); ?>&nbsp;<?php echo app('translator')->get('system.unit.km'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-speedometer me-2"></span><?php echo app('translator')->get('db.report.end_meter'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->end_meter)); ?>&nbsp;<?php echo app('translator')->get('system.unit.km'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-arrow-left-right me-2"></span><?php echo app('translator')->get('db.report.milage'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php if(!empty($report->end_meter)): ?><?php echo e(number_format($report->end_meter - $report->start_meter)); ?><?php else: ?><?php echo e(0); ?><?php endif; ?>&nbsp;<?php echo app('translator')->get('system.unit.km'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-droplet me-2"></span><?php echo app('translator')->get('db.report.light_oil'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->light_oil)); ?>&nbsp;<?php echo app('translator')->get('system.unit.liter'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-droplet me-2"></span><?php echo app('translator')->get('db.report.adblue'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->adblue)); ?>&nbsp;<?php echo app('translator')->get('system.unit.liter'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-droplet me-2"></span><?php echo app('translator')->get('db.report.adblue_handy'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->adblue_handy)); ?>&nbsp;<?php echo app('translator')->get('system.unit.ko'); ?></strong></p>
              </div>
              <div class="col-12 col-md-12">
                <p><span class="bi bi-chat-right-dots me-2"></span><?php echo app('translator')->get('db.report.note'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e($report->note); ?></strong></p>
              </div>
            </div>
          </div>
          
          <div class="card bg-light mb-3">
            <div class="card-header h6">ショートカット</div>
            <div class="row">
              <div class="col-6 col-md-6">
                <div class="card-body pe-0">
                  <p class="card-text">
                    <a href="/report/<?php echo e($report->id); ?>/edit?hash=report_oil" class="btn btn-xs btn-dark w-100 fw-bold">
                      <span class="bi bi-droplet-fill me-2"></span>
                      <?php echo app('translator')->get('db.report.oil'); ?>
                    </a>
                  </p>
                </div>
              </div>
              <div class="col-6 col-md-6">
                <div class="card-body ps-0">
                  <p class="card-text">
                    <a href="/report/<?php echo e($report->id); ?>/edit?hash=report_other" class="btn btn-xs btn-dark w-100 fw-bold">
                      <span class="bi bi-chat-right-dots-fill me-2"></span>
                      <?php echo app('translator')->get('db.report.note'); ?>
                    </a>
                  </p>
                </div>
              </div>
            </div>
          </div>
          
          <div class="card bg-white mb-3">
            <div class="card-header h6"><?php echo app('translator')->get('db.report_waypoints_short'); ?>（配車）</div>
            <div class="card-body pb-0 px-0">
              <p class="card-text px-3">
                <a href="/report/<?php echo e($report->id); ?>/waypoint/create" class="btn btn-xs btn-info w-100 fw-bold">
                  <span class="container-fluid px-0">
                    <span class="row">
                      <span class="col-2 pe-0">
                      </span>
                      <span class="col-8 px-0">
                        <span class="bi bi-geo-alt-fill me-2"></span>
                        <?php echo app('translator')->get('db.report_waypoints_short'); ?>を作成
                      </span>
                      <span class="col-2 ps-0 text-end">
                        <?php if($report->waypoints->count() > 0): ?>
                        <span class="badge rounded-pill bg-primary mt-1"><?php echo e($report->waypoints->count()); ?></span>
                        <?php endif; ?>
                      </span>
                    </span>
                  </span>
                </a>
              </p>
              <p class="card-text">
                <div class="table-responsive">
                  <table class="table table-hover text-nowrap">
                    <thead>
                      <tr>
                        <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_up'); ?><span class="sort_button ms-2" data-sort="take_up"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.address'); ?><span class="sort_button ms-2" data-sort="address"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
                        <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
                        <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.unit_price'); ?><span class="sort_button ms-2" data-sort="unit_price"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.type_id'); ?><span class="sort_button ms-2" data-sort="type_id"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_id'); ?><span class="sort_button ms-2" data-sort="billing_id"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_disposal_name'); ?><span class="sort_button ms-2" data-sort="billing_disposal_name"></span></th>
                        <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.highway_money'); ?><span class="sort_button ms-2" data-sort="highway_money"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.note'); ?><span class="sort_button ms-2" data-sort="note"></span></th>
                        <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.delete'); ?></th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $report->waypoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_waypoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr <?php if(!empty($report_waypoint->emergency)): ?>class="fw-bold bg-warning bg-opacity-10"<?php endif; ?>>
                        <td class="text-center tb-col-icon-button">
                          <a href="/report/<?php echo e($report->id); ?>/waypoint/<?php echo e($report_waypoint->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
                        </td>
                        <td class="text-start"><?php if(!empty($report_waypoint->emergency)): ?><span class="bi bi-info-circle-fill me-1 text-warning"></span><?php endif; ?><?php echo e($report_waypoint->take_up); ?></td>
                        <td class="text-start"><?php echo e($report_waypoint->take_down); ?></td>
                        <td class="text-start"><?php echo e($report_waypoint->address); ?></td>
                        <td class="text-start"><?php echo e($report_waypoint->item_name); ?></td>
                        <td class="text-end"><?php if(!empty($report_waypoint->quantity)): ?><?php echo e(number_format($report_waypoint->quantity, 2)); ?><?php if(!empty($report_waypoint->unit)): ?>&nbsp;<?php echo e(config('const.UNITS.'.$report_waypoint->unit)); ?><?php endif; ?> <?php endif; ?></td>
                        <td class="text-end"><?php if(!empty($report_waypoint->unit_price)): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->unit_price)); ?><?php endif; ?></td>
                        <td class="text-start"><?php echo e($report_waypoint->type->name); ?></td>
                        <td class="text-start"><?php if(!empty($report_waypoint->billing_id)): ?><?php echo e($report_waypoint->billing->name); ?><?php endif; ?></td>
                        <td class="text-start"><?php echo e($report_waypoint->billing_disposal_name); ?></td>
                        <td class="text-end"><?php if(!empty($report_waypoint->highway_money)): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->highway_money)); ?><?php if($report_waypoint->highway_money > 0 && !empty($report_waypoint->highway_payment)): ?>&nbsp;&#40;<?php echo e(config('const.PAYMENTS.'.$report_waypoint->highway_payment)); ?>&#41;<?php endif; ?> <?php endif; ?></td>
                        <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="<?php echo e($report_waypoint->note); ?>"><?php echo e(Str::limit($report_waypoint->note, 50)); ?></span></td>
                        <td class="text-center tb-col-icon-button">
                          <form action="/report/<?php echo e($report->id); ?>/waypoint/<?php echo e($report_waypoint->id); ?>" method="post" class="mb-0">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                          </form>
                        </td>
                      </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>
              </p>
            </div>
          </div>
          
          <div class="card bg-white mb-3">
            <div class="card-header h6"><?php echo app('translator')->get('db.report_partners_short'); ?></div>
            <div class="card-body pb-0 px-0">
              <p class="card-text px-3">
                <a href="/report/<?php echo e($report->id); ?>/partner/create" class="btn btn-xs btn-info w-100 fw-bold">
                  <span class="container-fluid px-0">
                    <span class="row">
                      <span class="col-2 pe-0">
                      </span>
                      <span class="col-8 px-0">
                        <span class="bi bi-geo-alt-fill me-2"></span>
                        <?php echo app('translator')->get('db.report_partners_short'); ?>を作成
                      </span>
                      <span class="col-2 ps-0 text-end">
                        <?php if($report->partners->count() > 0): ?>
                        <span class="badge rounded-pill bg-primary mt-1"><?php echo e($report->partners->count()); ?></span>
                        <?php endif; ?>
                      </span>
                    </span>
                  </span>
                </a>
              </p>
              <p class="card-text">
                <div class="table-responsive">
                  <table class="table table-hover text-nowrap">
                    <thead>
                      <tr>
                        <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_partner.partner_id'); ?><span class="sort_button ms-2" data-sort="partner_id"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_partner.company_name'); ?><span class="sort_button ms-2"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_partner.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_partner.car_number'); ?><span class="sort_button ms-2" data-sort="car_number"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_partner.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_partner.count'); ?><span class="sort_button ms-2" data-sort="count"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_partner.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
                        <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.delete'); ?></th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $report->partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                        <td class="text-center tb-col-icon-button">
                          <a href="/report/<?php echo e($report->id); ?>/partner/<?php echo e($report_partner->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
                        </td>
                        <td class="text-start"><?php echo e($report_partner->partner->name); ?></td>
                        <td class="text-start"><?php echo e($report_partner->partner->company_name); ?></td>
                        <td class="text-start"><?php echo e($report_partner->quantity); ?><?php echo app('translator')->get('system.unit.dai'); ?></td>
                        <td class="text-start"><?php echo e($report_partner->car_number); ?></td>
                        <td class="text-start"><?php echo e($report_partner->item_name); ?></td>
                        <td class="text-start"><?php echo e($report_partner->count); ?></td>
                        <td class="text-start"><?php echo e($report_partner->take_down); ?></td>
                        <td class="text-center tb-col-icon-button">
                          <form action="/report/<?php echo e($report->id); ?>/partner/<?php echo e($report_partner->id); ?>" method="post" class="mb-0">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                          </form>
                        </td>
                      </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>
              </p>
            </div>
          </div>
          
          <div class="card bg-white mb-3">
            <div class="card-header h6"><?php echo app('translator')->get('db.report_rests_short'); ?></div>
            <div class="card-body pb-0 px-0">
              <p class="card-text px-3">
                <a href="/report/<?php echo e($report->id); ?>/rest/create" class="btn btn-xs btn-info w-100 fw-bold">
                  <span class="container-fluid px-0">
                    <span class="row">
                      <span class="col-2 pe-0">
                      </span>
                      <span class="col-8 px-0">
                        <span class="bi bi-geo-alt-fill me-2"></span>
                        <?php echo app('translator')->get('db.report_rests_short'); ?>を作成
                      </span>
                      <span class="col-2 ps-0 text-end">
                        <?php if($report->rests->count() > 0): ?>
                        <span class="badge rounded-pill bg-primary mt-1"><?php echo e($report->rests->count()); ?></span>
                        <?php endif; ?>
                      </span>
                    </span>
                  </span>
                </a>
              </p>
              <p class="card-text">
                <div class="table-responsive">
                  <table class="table table-hover text-nowrap">
                    <thead>
                      <tr>
                        <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_rest.point'); ?><span class="sort_button ms-2" data-sort="point"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_rest.start_at'); ?><span class="sort_button ms-2" data-sort="start_at"></span></th>
                        <th class="text-start"><?php echo app('translator')->get('db.report_rest.end_at'); ?><span class="sort_button ms-2" data-sort="end_at"></span></th>
                        <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.delete'); ?></th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $report->rests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_rest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                        <td class="text-center tb-col-icon-button">
                          <a href="/report/<?php echo e($report->id); ?>/rest/<?php echo e($report_rest->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
                        </td>
                        <td class="text-start"><?php echo e($report_rest->point); ?></td>
                        <td class="text-start"><?php if(!empty($report_rest->start_at)): ?><?php echo e(date('G時i分', strtotime($report_rest->start_at))); ?><?php endif; ?></td>
                        <td class="text-start"><?php if(!empty($report_rest->end_at)): ?><?php echo e(date('G時i分', strtotime($report_rest->end_at))); ?><?php endif; ?></td>
                        <td class="text-center tb-col-icon-button">
                          <form action="/report/<?php echo e($report->id); ?>/rest/<?php echo e($report_rest->id); ?>" method="post" class="mb-0">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                          </form>
                        </td>
                      </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    <div class="col-12 col-md-6">
      <div class="card border-secondary mb-3">
        <div class="card-header">今日の他の<?php echo app('translator')->get('db.reports'); ?></div>
        <div class="card-body">
          <p class="card-text text-muted">他の<?php echo app('translator')->get('db.reports'); ?>が必要な場合はコチラから作成してください。</p>
          <p class="card-text">
            <a href="/report/create" class="btn btn-xs btn-primary w-100 fw-bold">
              <span class="bi bi-plus-square me-2"></span>
              <?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('system.command.create'); ?>
            </a>
          </p>
        </div>
      </div>
    </div>
  </div>
<?php else: ?>
  
  <div class="row">
    <div class="col-12 col-md-6">
      <div class="card border-primary mb-3">
        <div class="card-header">今日の<?php echo app('translator')->get('db.reports'); ?></div>
        <div class="card-body">
          <p class="card-text text-primary">コチラから新しい<?php echo app('translator')->get('db.reports'); ?>を作成してください。</p>
          <p class="card-text">
            <a href="/report/create" class="btn btn-xs btn-primary w-100 fw-bold">
              <span class="bi bi-plus-square me-2"></span>
              <?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('system.command.create'); ?>
            </a>
          </p>
        </div>
      </div>
    </div>
  </div>
<?php endif; ?>
</div>
<script>
  let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/script-del_check', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/home/index.blade.php ENDPATH**/ ?>