
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
  <head>
    <title><?php echo e(config('app.name', 'Laravel')); ?></title>
    <?php echo $__env->make('common/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(!empty($search_target)): ?>
    <style>
      @media (max-width: 767.98px) {
        .sidebar {
          top: 3.25rem;
        }
        .sidebar-sticky {
          height: calc(100vh - 200px);
        }
      }
    </style>
    <?php else: ?>
    <style>
      @media (max-width: 767.98px) {
        .sidebar-sticky {
          height: calc(100vh - 150px);
        }
      }
    </style>
    <?php endif; ?>
    <?php if(!empty($params)): ?>
    <script>
      inParams = <?php echo json_encode($params, 15, 512) ?>;
    </script>
    <?php endif; ?>
  </head>
  <body>
    <nav class="navbar navbar-expand-md sticky-top navbar-dark bg-primary">
      <div class="container-fluid">
        <a class="app-name navbar-brand ms-0 px-2" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('img/icon/32x32.png')); ?>" class="navbar-logo me-2" /><?php echo e(config('app.name', 'Laravel')); ?></a>
        <button class="navbar-toggler position-absolute top-0 end-0 mt-3 me-3 d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu" aria-controls="SidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <?php if(!empty($search_target)): ?>
        <input id="search_box" class="form-control form-control-dark w-100 mt-3 mt-md-0" type="search" placeholder="<?php if(!empty($search_target)): ?><?php echo e($search_target); ?><?php endif; ?>" aria-label="search" name="search" value="<?php if(!empty($params['search'])): ?><?php echo e($params['search']); ?><?php endif; ?>" autocomplete="off">
        <?php else: ?>
        <input id="search_box" type="hidden">
        <?php endif; ?>
        <div class="d-none d-md-block">
          <ul class="navbar-nav ms-0 ps-2 mt-2 mt-md-0 text-right">
            <li class="nav-item text-nowrap">
              <a class="nav-link" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <span class="bi bi-door-open-fill"></span><span class="ms-2"><?php echo app('translator')->get('system.command.logout'); ?></span>
              </a>
              <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                <?php echo csrf_field(); ?>
              </form>
            </li>
          </ul>
        </div>
      </div>
    </nav>
    <div class="container-fluid">
      <div class="row">
        <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse mt-3 mt-md-0">
          <div class="sidebar-sticky pt-3">
            <h6 class="d-flex justify-content-between align-items-center px-3 mt-2 mb-4">
              <span class="text-primary fw-bold"><?php echo e(Auth::user()->name); ?><small class="ms-1"><?php echo app('translator')->get('system.honorific.sama'); ?></small></span>
            </h6>
            <?php echo $__env->make('common/main/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          </div>
        </nav>
        <main role="main" class="col-md-9 ms-sm-auto col-lg-10 p-md-4 mt-3 mt-md-0">
          <?php echo $__env->yieldContent('content'); ?>
        </main>
      </div>
    </div>
    <script>
        window.addEventListener('load', function() {
            document.getElementById('search_box').addEventListener('search', function() {
              let requests = {
                search: this.value
              }
              let url = getRequestUrl(requests);
              if (!url) return;

              window.location.href = url;
              return;
            }, false);
        }, false);
    </script>
  </body>
</html><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/common/main/layout.blade.php ENDPATH**/ ?>