<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo e(date('Y年n月j日', strtotime('today'))); ?> <?php echo app('translator')->get('db.report_waypoint.emergency'); ?></h1>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-12 col-md">
      <a href="./emergency/create" class="btn btn-warning m-2 fw-bold"><span class="bi bi-info-circle-fill me-2"></span><?php echo app('translator')->get('db.report_waypoint.emergency'); ?></a>
    </div>
    <div class="col-12 col-md text-md-end">
      <?php if(session()->has('checkpoint')): ?>
      <a href="<?php echo e(session()->get('checkpoint')); ?>" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
      <?php else: ?>
      <a href="../" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
      <?php endif; ?>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-start"><?php echo app('translator')->get('db.report.user_id'); ?></th>
              <th class="text-start"><?php echo app('translator')->get('db.report.car_id'); ?></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_up'); ?><span class="sort_button ms-2" data-sort="take_up"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.address'); ?><span class="sort_button ms-2" data-sort="address"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
              <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
              <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.unit_price'); ?><span class="sort_button ms-2" data-sort="unit_price"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.type_id'); ?><span class="sort_button ms-2" data-sort="type_id"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_id'); ?><span class="sort_button ms-2" data-sort="billing_id"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_disposal_name'); ?><span class="sort_button ms-2" data-sort="billing_disposal_name"></span></th>
              <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.highway_money'); ?><span class="sort_button ms-2" data-sort="highway_money"></span></th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $report_waypoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_waypoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="text-start"><?php echo e($report_waypoint->report->user->name); ?></td>
              <td class="text-start"><?php echo e($report_waypoint->report->car->number); ?></td>
              <td class="text-start"><?php if(!empty($report_waypoint->emergency)): ?><span class="bi bi-info-circle-fill me-1 text-warning"></span><?php endif; ?><?php echo e($report_waypoint->take_up); ?></td>
              <td class="text-start"><?php echo e($report_waypoint->take_down); ?></td>
              <td class="text-start"><?php echo e($report_waypoint->address); ?></td>
              <td class="text-start"><?php echo e($report_waypoint->item_name); ?></td>
              <td class="text-end"><?php echo e(number_format($report_waypoint->quantity, 2)); ?><?php if(!empty($report_waypoint->unit)): ?>&nbsp;<?php echo e(config('const.UNITS.'.$report_waypoint->unit)); ?><?php endif; ?></td>
              <td class="text-end"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->unit_price)); ?></td>
              <td class="text-start"><?php echo e($report_waypoint->type->name); ?></td>
              <td class="text-start"><?php if(!empty($report_waypoint->billing_id)): ?><?php echo e($report_waypoint->billing->name); ?><?php endif; ?></td>
              <td class="text-start"><?php echo e($report_waypoint->billing_disposal_name); ?></td>
              <td class="text-end"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->highway_money)); ?><?php if($report_waypoint->highway_money > 0 && !empty($report_waypoint->highway_payment)): ?>&nbsp;&#40;<?php echo e(config('const.PAYMENTS.'.$report_waypoint->highway_payment)); ?>&#41;<?php endif; ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common/pagination', ['tables' => $report_waypoints], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php echo $__env->make('common/script-del_check', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/_emergency/index.blade.php ENDPATH**/ ?>