<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo app('translator')->get('db.cars'); ?> <?php echo app('translator')->get('system.title.index'); ?></h1>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col">
      <a href="/car/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span><?php echo app('translator')->get('system.command.create'); ?></a>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th>
              <th class="text-center tb-col-id"><?php echo app('translator')->get('db.car.id'); ?><span class="sort_button ms-2" data-sort="id"></span</th>
              <th class="text-start"><?php echo app('translator')->get('db.car.name'); ?><span class="sort_button ms-2" data-sort="name"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.car.number'); ?><span class="sort_button ms-2" data-sort="number"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.car.maker'); ?><span class="sort_button ms-2" data-sort="maker"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.car.use'); ?><span class="sort_button ms-2" data-sort="use"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.car.inspection_at'); ?><span class="sort_button ms-2" data-sort="inspection_at"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.car.inspection_next_at'); ?><span class="sort_button ms-2" data-sort="inspection_next_at"></span></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.delete'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/car/<?php echo e($car->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-center tb-col-id"><?php echo e($car->id); ?></td>
              <td class="text-start"><?php echo e($car->name); ?></td>
              <td class="text-start"><?php echo e($car->number); ?></td>
              <td class="text-start"><?php echo e($car->maker); ?></td>
              <td class="text-start"><?php echo app('translator')->get('db.car.use-'.$car->use); ?></td>
              <td class="text-start"><?php if(!empty($car->inspection_at)): ?><?php echo e(date('Y年n月j日', strtotime($car->inspection_at))); ?><?php endif; ?></td>
              <td class="text-start"><?php if(!empty($car->inspection_next_at)): ?><?php echo e(date('Y年n月', strtotime($car->inspection_next_at))); ?><?php endif; ?></td>
              <td class="text-center tb-col-icon-button">
                <form action="/car/<?php echo e($car->id); ?>" method="post">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common/pagination', ['tables' => $cars], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php echo $__env->make('common/script-sort', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('common/script-del_check', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/car/index.blade.php ENDPATH**/ ?>