<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">
      <?php if(Route::is('work.index')): ?>
        <?php echo app('translator')->get('db.works'); ?>
      <?php endif; ?>
      <?php if(Route::is('emergency.index')): ?>
        <?php echo app('translator')->get('db.report_waypoint.emergency'); ?>
      <?php endif; ?>
      </h1>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php echo $__env->make('common/email-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-12 col-md">
      <a href="/report/create?start_at=<?php echo e(date('Y-m-d', strtotime($params['start_at']))); ?>" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span><?php echo app('translator')->get('db.reports'); ?><?php echo app('translator')->get('system.command.create'); ?></a>
    </div>
    <div class="col col-md p-2">
    </div>
    <div class="col col-md p-2">
    </div>
    <div class="col-12 col-md p-2">
      <input type="date" id="search_start_at" class="form-control" name="start_at" placeholder="" value="<?php echo e(old('start_at', date('Y-m-d', strtotime($params['start_at'])))); ?>">
    </div>
  </div>
  <div class="row">
    <div class="col-12 col-md">
      <span class="m-2 text-primary">配車を行う運転日報を選択してください。対象の運転日報がまだ無い場合は上のボタンから作成してください。</span>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <!-- <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th> -->
              <th class="text-start"><?php echo app('translator')->get('db.reports'); ?> 日付</th>
              <th class="text-start"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('db.report.user_id'); ?></th>
              <th class="text-start"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('db.report.car_id'); ?></th>
              <?php if(Route::is('work.index')): ?><th class="text-center tb-col-icon-button"><?php echo app('translator')->get('db.works'); ?><?php endif; ?></th>
              <?php if(Route::is('emergency.index')): ?><th class="text-center tb-col-icon-button"><?php echo app('translator')->get('db.report_waypoint.emergency'); ?><?php endif; ?></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('db.reports'); ?><?php echo app('translator')->get('system.command.show'); ?></th>
              <!-- <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.delete'); ?></th> -->
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <!-- <td class="text-center tb-col-icon-button">
                <a href="/report/<?php echo e($report->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td> -->
              <td class="text-start"><?php echo e(date('Y年n月j日', strtotime($report->start_at))); ?></td>
              <td class="text-start"><?php echo e($report->user->name); ?></td>
              <td class="text-start"><?php echo e($report->car->number); ?></td>
              <?php if(Route::is('work.index')): ?>
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/work/<?php echo e($report->id); ?>/waypoint" class="btn btn-xs btn-info"><span class="bi bi-calendar3"></span></a>
                  <?php if($report->waypoints->count() > 0): ?>
                  <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->waypoints->count()); ?></span>
                  <?php endif; ?>
                </div>
              </td>
              <?php endif; ?>
              <?php if(Route::is('emergency.index')): ?>
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/work/<?php echo e($report->id); ?>/waypoint/emergency" class="btn btn-xs btn-warning fw-bold"><span class="bi bi-info-circle-fill me-2"></span><?php echo app('translator')->get('db.report_waypoint.emergency'); ?></a>
                </div>
              </td>
              <?php endif; ?>
              <td class="text-center tb-col-icon-button">
                <a href="/report/<?php echo e($report->id); ?>" class="btn btn-xs btn-primary"><span class="bi bi-stickies-fill"></span></a>
              </td>
              <!-- <td class="text-center tb-col-icon-button">
                <form action="/report/<?php echo e($report->id); ?>" method="post">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td> -->
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common/pagination', ['tables' => $reports], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php echo $__env->make('common/script-del_check', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    window.addEventListener('load', function() {
        document.getElementById('search_start_at').addEventListener('change', function() {
          let requests = {
            start_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
    }, false);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/work/index.blade.php ENDPATH**/ ?>