<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo e($report_waypoints->first()->billing->name); ?> <?php echo app('translator')->get('db.pdf_billing'); ?> <?php echo app('translator')->get('system.title.details'); ?></h1>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <form action="<?php echo e(route('pdf.billing.output')); ?>" method="get">
    <?php echo csrf_field(); ?>
    <div class="row">
      <div class="d-none d-md-block col-12 col-md">
      </div>
      <div class="col col-md p-2">
      </div>
      <div class="col-12 col-md p-2">
      </div>
      <div class="col-12 col-md text-md-end">
        <?php if(session()->has('checkpoint')): ?>
        <a href="<?php echo e(session()->get('checkpoint')); ?>" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
        <?php else: ?>
        <a href="../" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
        <?php endif; ?>
      </div>
    </div>
    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-hover text-nowrap">
            <thead>
              <tr>
                <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th>
                <th class="text-center">日付</th>
                <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_up'); ?><span class="sort_button ms-2" data-sort="take_up"></span></th>
                <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
                <th class="text-end">数量<span class="sort_button ms-2" data-sort="quantity"></span></th>
                <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.unit'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
                <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.unit_price'); ?><span class="sort_button ms-2" data-sort="unit_price"></span></th>
                <th class="text-end">金額</th>
              </tr>
            </thead>
            <tbody>
              <?php
                $total_price = 0;
              ?>
              <?php $__currentLoopData = $report_waypoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_waypoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td class="text-center tb-col-icon-button">
                  <a href="/report/<?php echo e($report_waypoint->report_id); ?>/waypoint/<?php echo e($report_waypoint->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
                </td>
                <td class="text-center"><?php echo e(date('n月j日', strtotime($report_waypoint->date))); ?></td>
                <td class="text-start"><?php if(!empty($report_waypoint->emergency)): ?><span class="bi bi-info-circle-fill me-1 text-warning"></span><?php endif; ?><?php echo e($report_waypoint->take_up); ?></td>
                <td class="text-start"><?php echo e($report_waypoint->take_down); ?></td>
                <td class="text-end"><?php if(!empty($report_waypoint->quantity)): ?><?php echo e(number_format($report_waypoint->quantity, 2)); ?><?php endif; ?></td>
                <td class="text-end"><?php if(!empty($report_waypoint->unit)): ?><?php echo e(config('const.UNITS.'.$report_waypoint->unit)); ?><?php endif; ?></td>
                <td class="text-end"><?php if(!empty($report_waypoint->unit_price)): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->unit_price)); ?><?php endif; ?></td>
                <td class="text-end"><?php if(!empty($report_waypoint->quantity) && !empty($report_waypoint->unit_price)): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format(round($report_waypoint->quantity * $report_waypoint->unit_price))); ?><?php endif; ?></td>
              </tr>
              <?php
                if (!empty($report_waypoint->quantity) && !empty($report_waypoint->unit_price)) {
                  $total_price = $total_price + round($report_waypoint->quantity * $report_waypoint->unit_price);
                }
              ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
              <tr>
                <td class="text-center tb-col-icon-button">
                </td>
                <td class="text-center" colspan="6">小計</td>
                <td class="text-end text-info fw-bold"><span id="table_sum_price"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($total_price)); ?></span></td>
              </tr>
              <tr>
                <td class="text-center tb-col-icon-button">
                </td>
                <td class="text-center" colspan="6">消費税</td>
                <?php
                  $tax_price = round($total_price * (intval(old('tax', $params['default_tax'])) / 100));
                ?>
                <td class="text-end text-info fw-bold"><span id="table_tax_price"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($tax_price)); ?></span></td>
              </tr>
              <tr>
                <td class="text-center tb-col-icon-button">
                </td>
                <td class="text-center" colspan="6">合計</td>
                <td class="text-end text-info fw-bold"><span id="table_total_price"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($total_price + $tax_price)); ?></span></td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
    </div>
    <form action="<?php echo e(route('pdf.billing.output')); ?>" method="get">
      <input type="hidden" class="d-none" name="billing_id" value="<?php echo e($report_waypoints->first()->billing_id); ?>">
      <input type="hidden" class="d-none" name="from_at" value="<?php echo e($params['from_at']); ?>">
      <input type="hidden" class="d-none" name="to_at" value="<?php echo e($params['to_at']); ?>">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2"><?php echo app('translator')->get('db.pdf_billing'); ?> <?php echo app('translator')->get('system.title.information'); ?></div>
        <div class="card-body">
          <div class="container-fluid p-0 m-0">
            <div class="row">
              <div class="col-12 col-md-3">
                <div class="form-group mb-4">
                  <label class="form-label mb-2">前月御請求額</label>
                  <div class="input-group <?php $__errorArgs = ['last_month_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <span class="input-group-text"><?php echo app('translator')->get('system.unit.yen-mark'); ?></span>
                    <input type="number" id="last_month_invoice" class="form-control <?php $__errorArgs = ['last_month_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="last_month_invoice" value="<?php echo e(old('last_month_invoice')); ?>">
                  </div>
                  <?php $__errorArgs = ['last_month_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>
              <div class="col-12 col-md-3">
                <div class="form-group mb-4">
                  <label class="form-label mb-2">御入金額</label>
                  <div class="input-group <?php $__errorArgs = ['last_month_payment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <span class="input-group-text"><?php echo app('translator')->get('system.unit.yen-mark'); ?></span>
                    <input type="number" id="last_month_payment" class="form-control <?php $__errorArgs = ['last_month_payment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="last_month_payment" value="<?php echo e(old('last_month_payment')); ?>">
                  </div>
                  <?php $__errorArgs = ['last_month_payment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>
              <div class="col-12 col-md-3">
                <div class="form-group mb-4">
                  <label class="form-label mb-2">繰越金額</label>
                  <div class="input-group <?php $__errorArgs = ['this_month_carried'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <span class="input-group-text"><?php echo app('translator')->get('system.unit.yen-mark'); ?></span>
                    <input type="number" id="this_month_carried" class="form-control <?php $__errorArgs = ['this_month_carried'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="this_month_carried" value="<?php echo e(old('this_month_carried')); ?>">
                  </div>
                  <?php $__errorArgs = ['this_month_carried'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  <div class="form-text">自動計算または直接入力</div>
                </div>
              </div>
              <div class="col-12 col-md-3">
                <div class="form-group mb-4">
                  <label class="form-label mb-2">調整額</label>
                  <div class="input-group <?php $__errorArgs = ['this_month_adjust'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <span class="input-group-text"><?php echo app('translator')->get('system.unit.yen-mark'); ?></span>
                    <span class="input-group-text">-</span>
                    <input type="number" id="this_month_adjust" class="form-control <?php $__errorArgs = ['this_month_adjust'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="this_month_adjust" value="<?php echo e(old('this_month_adjust')); ?>">
                  </div>
                  <?php $__errorArgs = ['this_month_adjust'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>
              <div class="col-12 col-md-3">
                <div class="form-group mb-4">
                  <label class="form-label mb-2">消費税率</label>
                  <div class="input-group <?php $__errorArgs = ['tax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <input type="number" id="tax" class="form-control <?php $__errorArgs = ['tax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="tax" value="<?php echo e(old('tax', $params['default_tax'])); ?>">
                    <span class="input-group-text">%</span>
                  </div>
                  <?php $__errorArgs = ['tax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="invalid-feedback" role="alert"><strong><?php echo e($message); ?></strong></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>
              <div class="col-12 col-md-3">
                <div class="form-group mb-4">
                  <label class="form-label mb-2">当月御買上額</label>
                  <p id="calc_sum_price" class="mx-2 mt-1 text-info fw-bold"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($total_price)); ?></p>
                </div>
              </div>
              <div class="col-12 col-md-3">
                <div class="form-group mb-4">
                  <label class="form-label mb-2">消費税額</label>
                  <p id="calc_tax_price" class="mx-2 mt-1 text-info fw-bold"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($tax_price)); ?></p>
                </div>
              </div>
              <div class="col-12 col-md-3">
                <div class="form-group mb-4">
                  <label class="form-label mb-2">当月御請求額</label>
                  <p id="calc_total_price" class="mx-2 mt-1 text-info fw-bold"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($total_price + $tax_price)); ?></p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="row justify-content-center mb-4">
        <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">
          <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-printer-fill me-2"></span><?php echo app('translator')->get('db.pdf_billing'); ?>を<?php echo app('translator')->get('system.command.output'); ?></button>
        </div>
        <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
          <?php if(session()->has('checkpoint')): ?>
          <a href="<?php echo e(session()->get('checkpoint')); ?>" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
          <?php else: ?>
          <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
          <?php endif; ?>
        </div>
      </div>
    </form>
    <div class="row justify-content-center mt-4 mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">
      </div>
    </div>
  </form>
</div>
<script>
  window.addEventListener('load', function() {
      calcPrice(this);
      document.getElementById('last_month_invoice').addEventListener('change', function() {
        calcPrice(this);
      }, false);
      document.getElementById('last_month_payment').addEventListener('change', function() {
        calcPrice(this);
      }, false);
      document.getElementById('this_month_carried').addEventListener('change', function() {
        calcPrice(this);
      }, false);
      document.getElementById('this_month_adjust').addEventListener('change', function() {
        calcPrice(this);
      }, false);
      document.getElementById('tax').addEventListener('change', function() {
        calcPrice(this);
      }, false);
    }, false);

  function calcPrice(ele) {
    let total_price = <?php echo e($total_price); ?>;
    let tax =  Number(document.getElementById('tax').value);
    let last_month_invoice = Number(document.getElementById('last_month_invoice').value);
    let last_month_payment = Number(document.getElementById('last_month_payment').value);
    let this_month_carried = Number(document.getElementById('this_month_carried').value);
    let this_month_adjust = Number(document.getElementById('this_month_adjust').value);

    if (ele.id == 'last_month_invoice' || ele.id == 'last_month_payment') {
      this_month_carried = last_month_invoice - last_month_payment;
      document.getElementById('this_month_carried').value = this_month_carried;
    }

    let tax_price = Math.round(total_price * (tax / 100));
    document.getElementById('table_tax_price').innerHTML = "<?php echo app('translator')->get('system.unit.yen-mark'); ?>" + tax_price.toLocaleString();
    document.getElementById('calc_tax_price').innerHTML = "<?php echo app('translator')->get('system.unit.yen-mark'); ?>" + tax_price.toLocaleString();

    let sum_total_price = total_price + tax_price;
    document.getElementById('table_total_price').innerHTML = "<?php echo app('translator')->get('system.unit.yen-mark'); ?>" + sum_total_price.toLocaleString();

    let recalc_total_price = sum_total_price + this_month_carried - this_month_adjust;
    document.getElementById('calc_total_price').innerHTML = "<?php echo app('translator')->get('system.unit.yen-mark'); ?>" + recalc_total_price.toLocaleString();

  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/pdf/billing/details.blade.php ENDPATH**/ ?>