<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('db.report_partners'); ?> <?php echo app('translator')->get('system.title.index'); ?></h1>
    </div>
  </div>
  <div class="row mb-3">
    <div class="col">
      <?php echo $__env->make('report/info', ['report' => $report], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-12 col-md">
      <a href="/report/<?php echo e($report->id); ?>/partner/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span><?php echo app('translator')->get('system.command.create'); ?></a>
    </div>
    <div class="col-12 col-md text-md-end">
      <span class="position-relative d-inline-block m-2">
        <a href="/report/<?php echo e($report->id); ?>/waypoint" class="btn btn-xs btn-info"><span class="bi bi-geo-alt-fill"></span></a>
        <?php if($report->waypoints->count() > 0): ?>
        <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->waypoints->count()); ?></span>
        <?php endif; ?>
      </span>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/<?php echo e($report->id); ?>/partner" class="btn btn-xs btn-info"><span class="bi bi-people-fill"></span></a>
        <?php if($report->partners->count() > 0): ?>
        <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->partners->count()); ?></span>
        <?php endif; ?>
      </span>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/<?php echo e($report->id); ?>/rest" class="btn btn-xs btn-info"><span class="bi bi-tree-fill"></span></a>
        <?php if($report->rests->count() > 0): ?>
        <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->rests->count()); ?></span>
        <?php endif; ?>
      </span>
      <?php if(session()->has('checkpoint')): ?>
      <a href="<?php echo e(session()->get('checkpoint')); ?>" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
      <?php else: ?>
      <a href="../" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
      <?php endif; ?>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_partner.partner_id'); ?><span class="sort_button ms-2" data-sort="partner_id"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_partner.company_name'); ?><span class="sort_button ms-2"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_partner.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_partner.car_number'); ?><span class="sort_button ms-2" data-sort="car_number"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_partner.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_partner.count'); ?><span class="sort_button ms-2" data-sort="count"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_partner.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.delete'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $report_partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/report/<?php echo e($report->id); ?>/partner/<?php echo e($report_partner->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-start"><?php echo e($report_partner->partner->name); ?></td>
              <td class="text-start"><?php echo e($report_partner->partner->company_name); ?></td>
              <td class="text-start"><?php echo e($report_partner->quantity); ?><?php echo app('translator')->get('system.unit.dai'); ?></td>
              <td class="text-start"><?php echo e($report_partner->car_number); ?></td>
              <td class="text-start"><?php echo e($report_partner->item_name); ?></td>
              <td class="text-start"><?php echo e($report_partner->count); ?></td>
              <td class="text-start"><?php echo e($report_partner->take_down); ?></td>
              <td class="text-center tb-col-icon-button">
                <form action="/report/<?php echo e($report->id); ?>/partner/<?php echo e($report_partner->id); ?>" method="post">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common/pagination', ['tables' => $report_partners], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php echo $__env->make('common/script-del_check', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/report/partner/index.blade.php ENDPATH**/ ?>