<html lang="ja">
  <head>
    <title>御請求書</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
      /* font */
      @font-face{
        font-family: migmix;
        font-style: normal;
        font-weight: normal;
        src: url("<?php echo e(storage_path('fonts/migmix-2p-regular.ttf')); ?>") format('truetype');
      }
      @font-face{
        font-family: migmix;
        font-style: bold;
        font-weight: bold;
        src: url("<?php echo e(storage_path('fonts/migmix-2p-bold.ttf')); ?>") format('truetype');
      }
      body {
        font-family: migmix;
        line-height: 80%;
      }

      /* payment */
      .payment_table {
        border: 3px solid #000;
        border-collapse: collapse;
      }
      .payment_table tr td {
        border: 3px solid #000;
        padding: 4px 30px;
      }

      /* money */
      .money_table {
        border: 3px solid #000;
        border-collapse: collapse;
        width: 100%;
      }
      .money_table tr th {
        padding: 3px;
        border: 3px solid #000;
      }
      .money_table tr td {
        padding: 3px;
        border: 3px solid #000;
      }

      /* detail */
      .detail_table {
        border: 1px solid #000;
        border-collapse: collapse;
        width: 100%;
        table-layout: fixed;
      }
      .detail_table tr th {
        padding: 3px;
        border: 1px solid #000;
      }
      .detail_table tr td {
        padding: 0px;
        border: 1px solid #000;
        word-break:break-all;
        word-wrap:break-word;
      }
      .detail_table .col_1 {
        width: 12%;
      }
      .detail_table .col_2 {
      }
      .detail_table .col_3 {
        width: 12%;
      }
      .detail_table .col_4 {
        width: 8%;
      }
      .detail_table .col_5 {
        width: 12%;
      }
      .detail_table .col_6 {
        width: 15%;
      }
      .detail_table .col_7 {
        width: 8%;
      }

      /* table common */
      .table-text {
        padding: 1.5px;
      }
      .table-text-secondary {
        padding: 1.5px;
        border-top: 1px solid #000;
      }
      .table-text-total {
        padding: 12px 3px;
      }

      /* text common */
      .text-left {
        text-align: left;
      }
      .text-center {
        text-align: center;
      }
      .text-right {
        text-align: right;
      }
      .fw-bold {
        font-weight: bold;
      }

      /* format */
      .wrap {
        display: block;
        width: 100%;
      }
      .clearfix:after {
        content: "";
        display: block;
        clear: both;
      }
      .float-left {
        float: left;
      }
      .float-right {
        float: right;
      }
      .ps-1 {
        padding-left: 10px;
      }
      .ps-2 {
        padding-left: 20px;
      }

      /* format */
      .payment-box {
        width: 330px;
        padding: 3px 1px;
        border: 2px solid #000;
      }

    </style>
  </head>
  <body>
    <div class="wrap clearfix">
      <div class="float-left ps-1"></div>
      <div class="float-right"><?php echo e(date('Y年n月j日', strtotime('today'))); ?></div>
    </div>
    <div class="wrap clearfix" style="margin-top:13px;">
      <div class="float-left ps-1">〒<?php echo e($billing->zip_code); ?></div>
      <div class="float-right fw-bold"><span style="font-size:1.8em; letter-spacing:0.6em; margin-right:-0.6em;">御請求書</span></div>
    </div>
    <div class="wrap clearfix" style="margin-top:0px;">
      <div class="float-left ps-1"><?php echo e($billing->address_1); ?></div>
      <div class="float-right"></div>
    </div>
    <div class="wrap clearfix" style="margin-top:0px;">
      <div class="float-left ps-1"><?php echo e($billing->address_2); ?></div>
      <div class="float-right"></div>
    </div>
    <div class="wrap clearfix" style="margin-top:5px;">
      <div class="float-left ps-1"></div>
      <div class="float-right"><span style="font-size:1.6em;">株式会社宮川運輸</span></div>
    </div>
    <div class="wrap clearfix" style="margin-top:10px;">
      <div class="float-left ps-2 fw-bold"><span style="font-size:1.6em;"><?php echo e($billing->name); ?></span><span style="font-size:1.1em; margin-left:1.5em;">御中</span></div>
      <div class="float-right"></div>
    </div>
    <div class="wrap clearfix" style="margin-top:20px;">
      <div class="float-left ps-1"></div>
      <div class="float-right"><span style="font-size:0.9em;">〒455-0843<span style="margin-left:1em;">名古屋市港区錦町13番12号</span></span></div>
    </div>
    <div class="wrap clearfix" style="margin-top:0px;">
      <div class="float-left ps-1"><span style="font-size:1.1em;">毎度ありがとうございます。</span></div>
      <div class="float-right"><span style="font-size:0.9em;">TEL&nbsp;052-398-6058<span style="margin-left:1em;">FAX&nbsp;052-398-6059</span></span></div>
    </div>
    <div class="wrap clearfix" style="margin-top:6px;">
      <div class="float-left ps-1"><span style="font-size:1.1em;">下記の通りご請求させて頂きます。</span></div>
      <div class="float-right">
        <table class="payment_table">
          <tbody>
            <tr>
              <td class="text-center">名古屋銀行&nbsp;港支店（普）3608143</td>
            </tr>
            <tr>
              <td class="text-center">カ）ミヤガワウンユ</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
    <div class="wrap" style="margin-top:7px;">
      <table class="money_table">
        <thead>
          <tr>
            <th>前月御請求額</th>
            <th>御入金額</th>
            <th>繰越金額</th>
            <th>調整額</th>
            <th>当月御買上額</th>
            <th>消費税額</th>
            <th>当月御請求額</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <?php
              $tax_price = round($total_price * $tax);
            ?>
            <td class="text-center"><span style="font-size:0.9em;"><?php if(!empty($params['last_month_invoice'])): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($params['last_month_invoice'])); ?><?php else: ?><?php echo e('-'); ?><?php endif; ?></span></td>
            <td class="text-center"><span style="font-size:0.9em;"><?php if(!empty($params['last_month_payment'])): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($params['last_month_payment'])); ?><?php else: ?><?php echo e('-'); ?><?php endif; ?></span></td>
            <td class="text-center"><span style="font-size:0.9em;"><?php if(!empty($params['this_month_carried'])): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($params['this_month_carried'])); ?><?php else: ?><?php echo e('-'); ?><?php endif; ?></span></td>
            <td class="text-center"><span style="font-size:0.9em;"><?php if(!empty($params['this_month_adjust'])): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e('-'.number_format($params['this_month_adjust'])); ?><?php else: ?><?php echo e('-'); ?><?php endif; ?></span></td>
            <td class="text-center"><span style="font-size:0.9em;"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($total_price)); ?></span></td>
            <td class="text-center"><span style="font-size:0.9em;"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($tax_price)); ?></span></td>
            <?php
              $recalc_total_price = $total_price + $tax_price;
              $recalc_total_price = $recalc_total_price + intval($params['this_month_carried']);
              $recalc_total_price = $recalc_total_price - intval($params['this_month_adjust']);
            ?>
            <td class="text-center fw-bold"><span style="font-size:1.2em;"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($recalc_total_price)); ?></span></td>
          </tr>
        </tbody>
      </table>
    </div>
    <div class="wrap" style="margin-top:13px;">
      <table class="detail_table">
        <thead>
          <tr>
            <th class="text-center col_1">日付</th>
            <th class="text-center col_2">品名</th>
            <th class="text-center col_3">数量</th>
            <th class="text-center col_4">単位</th>
            <th class="text-center col_5">単価</th>
            <th class="text-center col_6">金額</th>
            <th class="text-center col_7">備考</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $invoices->cursor(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td class="text-center"><div class="table-text"><?php echo e(date('n月j日', strtotime($invoice->date))); ?></div></td>
            <td class="text-center"><div class="table-text"><?php echo e($invoice->item_1); ?></div><div class="table-text-secondary"><?php echo e($invoice->item_2); ?>&nbsp;</div></td>
            <td class="text-center"><div class="table-text"><?php if(!empty($invoice->quantity)): ?><?php echo e(number_format($invoice->quantity, 2)); ?><?php endif; ?></div></td>
            <td class="text-center"><div class="table-text"><?php if(!empty($invoice->unit)): ?><?php echo e(config('const.UNITS.'.$invoice->unit)); ?><?php endif; ?></div></td>
            <td class="text-center"><div class="table-text"><?php if(!empty($invoice->unit_price)): ?><?php echo e(number_format($invoice->unit_price)); ?><?php endif; ?></div></td>
            <td class="text-center"><div class="table-text"><?php if(!empty($invoice->quantity) && !empty($invoice->unit_price)): ?><?php echo e(number_format($invoice->unit_price*$invoice->quantity)); ?><?php endif; ?></div></td>
            <td class="text-center"><div class="table-text"></div></td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php
            $count = 9 - $invoices->count();
          ?>
          <?php for($i = 0; $i < $count; $i++): ?>
          <tr>
            <td class="text-center"><div class="table-text">&nbsp;</div><div class="table-text">&nbsp;</div></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
          </tr>
          <?php endfor; ?>
          <tr>
            <td class="text-center"></td>
            <td class="text-center"><div class="table-text-total">小計</div></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"><div class="table-text-total"><?php echo e(number_format($total_price)); ?></div></td>
            <td class="text-center"></td>
          </tr>
          <tr>
            <td class="text-center"></td>
            <td class="text-center"><div class="table-text-total">消費税</div></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"><div class="table-text-total"><?php echo e(number_format($tax_price)); ?></div></td>
            <td class="text-center"></td>
          </tr>
          <tr>
            <td class="text-center"></td>
            <td class="text-center"><div class="table-text-total">合計</div></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"></td>
            <td class="text-center"><div class="table-text-total"><?php echo e(number_format($total_price + $tax_price)); ?></div></td>
            <td class="text-center"></td>
          </tr>
        </tbody>
      </table>
    </div>
  </body>
</html><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/pdf/billing/output.blade.php ENDPATH**/ ?>