<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
  <head>
    <title><?php echo e(config('app.name', 'Laravel')); ?></title>
    <?php echo $__env->make('common/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </head>
  <body>
    <div class="container-fluid">
      <div class="row">
        <main role="main" class="col-md-9 mx-sm-auto col-lg-10 p-md-4 mt-3 mt-md-0">
          <div class="container-fluid px-0 mt-2 mb-4">
            <div class="row text-center mb-3">
              <div class="col">
                <h1 class="h2">緊急配車詳細情報</h1>
              </div>
            </div>
            <div class="row">
              <div class="col">
                <div class="card border-secondary mb-3 w-100">
                  <div class="card-header mb-2"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('system.title.information'); ?></div>
                  <div class="card-body">
                    <div class="container-fluid p-0 m-0">
                      <div class="row">
                        <div class="col-12 col-md-12">
                          <p>日付&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(date('Y年n月j日', strtotime($report->start_at))); ?></strong></p>
                        </div>
                        <div class="col-12 col-md-6">
                          <p><?php echo app('translator')->get('db.report.user_id'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e($report->user->name); ?></strong></p>
                        </div>
                        <div class="col-12 col-md-6">
                          <p><?php echo app('translator')->get('db.report.car_id'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e($report->car->number); ?></strong></p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="row mt-2">
              <div class="col">
                <div class="card border-secondary mb-3 w-100">
                  <div class="card-header mb-2">本日の既存配車予定</div>
                  <div class="card-body pt-1 pb-2">
                    <?php if($report->waypoints->count() > 0): ?>
                    <div class="table-responsive">
                      <table class="table table-hover text-nowrap">
                        <thead>
                          <tr>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_up'); ?><span class="sort_button ms-2" data-sort="take_up"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
                            <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.type_id'); ?><span class="sort_button ms-2" data-sort="type_id"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.address'); ?><span class="sort_button ms-2" data-sort="address"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.note'); ?><span class="sort_button ms-2" data-sort="note"></span></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php $__currentLoopData = $report->waypoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_waypoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <?php if(!empty($report_waypoint->emergency)): ?>
                          <?php continue; ?>
                          <?php endif; ?>
                          <tr>
                            <td class="text-start"><?php echo e($report_waypoint->take_up); ?></td>
                            <td class="text-start"><?php echo e($report_waypoint->take_down); ?></td>
                            <td class="text-start"><?php echo e($report_waypoint->item_name); ?></td>
                            <td class="text-end"><?php if(!empty($report_waypoint->quantity)): ?><?php echo e(number_format($report_waypoint->quantity, 2)); ?><?php if(!empty($report_waypoint->unit)): ?>&nbsp;<?php echo e(config('const.UNITS.'.$report_waypoint->unit)); ?><?php endif; ?> <?php endif; ?></td>
                            <td class="text-start"><?php echo e($report_waypoint->type->name); ?></td>
                            <td class="text-start"><?php echo e($report_waypoint->address); ?></td>
                            <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="<?php echo e($report_waypoint->note); ?>"><?php echo e(Str::limit($report_waypoint->note, 50)); ?></span></td>
                          </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                      </table>
                    </div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            </div>
            <?php if($report->waypoints->count() > 0): ?>
            <?php $__currentLoopData = $report->waypoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_waypoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(empty($report_waypoint->emergency)): ?>
            <?php continue; ?>
            <?php endif; ?>
            <div class="row mt-2">
              <div class="col">
                <div class="card border-warning bg-warning bg-opacity-10 mb-3 w-100">
                  <div class="card-header mb-2 text-white bg-warning"><span class="bi bi-info-circle-fill me-1"></span><strong>緊急配車</strong></div>
                  <div class="card-body pt-1 pb-2">
                    <div class="table-responsive">
                      <table class="table table-hover text-nowrap">
                        <thead>
                          <tr>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_up'); ?><span class="sort_button ms-2" data-sort="take_up"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
                            <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.type_id'); ?><span class="sort_button ms-2" data-sort="type_id"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.address'); ?><span class="sort_button ms-2" data-sort="address"></span></th>
                            <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.note'); ?><span class="sort_button ms-2" data-sort="note"></span></th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td class="text-start"><?php echo e($report_waypoint->take_up); ?></td>
                            <td class="text-start"><?php echo e($report_waypoint->take_down); ?></td>
                            <td class="text-start"><?php echo e($report_waypoint->item_name); ?></td>
                            <td class="text-end"><?php if(!empty($report_waypoint->quantity)): ?><?php echo e(number_format($report_waypoint->quantity, 2)); ?><?php if(!empty($report_waypoint->unit)): ?>&nbsp;<?php echo e(config('const.UNITS.'.$report_waypoint->unit)); ?><?php endif; ?> <?php endif; ?></td>
                            <td class="text-start"><?php echo e($report_waypoint->type->name); ?></td>
                            <td class="text-start"><?php echo e($report_waypoint->address); ?></td>
                            <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="<?php echo e($report_waypoint->note); ?>"><?php echo e(Str::limit($report_waypoint->note, 50)); ?></span></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="row mb-3">
              <div class="col">
                <?php if(!empty($report_waypoint->address)): ?>
                <iframe src="https://maps.google.com/maps?output=embed&q=<?php echo e(urlencode($report_waypoint->address)); ?>&t=m&hl=ja&z=12" width="100%" height="450" frameborder="0" style="border:0;border-radius:0.25em;"></iframe>
                <p><a href="https://www.google.com/maps/dir/?api=1&destination=<?php echo e(urlencode($report_waypoint->address)); ?>&travelmode=driving&dir_action=navigate" class="btn btn-info w-100" target="_blank"><span class="bi bi-geo-alt-fill me-2"></span>ルート案内開始</a></p>
                <?php endif; ?>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </main>
  </body>
  <script>
    let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl);
    });
  </script>
</html>
<?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/_emergency/details.blade.php ENDPATH**/ ?>