<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('db.report.oil'); ?><?php echo app('translator')->get('system.title.total'); ?></h1>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="d-none d-md-block col-12 col-md">
    </div>
    <div class="col col-md p-2">
      <select id="search_user_id" class="form-select" name="user_id">
        <option value="all">すべて表示</option>
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($user->id); ?>" <?php if($params['user_id'] == $user->id): ?> selected  <?php endif; ?>><?php echo e($user->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    </div>
    <div class="col-12 col-md p-2">
      <input type="month" id="search_start_at" class="form-control" name="start_at" placeholder="" value="<?php echo e(old('start_at', date('Y-m', strtotime($params['start_at'])))); ?>">
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-start">日付</th>
              <th class="text-end"><?php echo app('translator')->get('db.report.light_oil'); ?><span class="sort_button ms-2" data-sort="light_oil"></span></th>
              <th class="text-end"><?php echo app('translator')->get('db.report.adblue'); ?><span class="sort_button ms-2" data-sort="adblue"></span></th>
              <th class="text-end"><?php echo app('translator')->get('db.report.adblue_handy'); ?><span class="sort_button ms-2" data-sort="adblue_handy"></span></th>
            </tr>
          </thead>
          <tbody>
            <?php
              $sumArray['light_oil'] = 0;
              $sumArray['adblue'] = 0;
              $sumArray['adblue_handy'] = 0;
            ?>
            <?php $__currentLoopData = $totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="text-start">
                <?php echo e(date('j日', strtotime($total->date))); ?>

              </td>
              <td class="text-end">
                <?php if(!empty($total->sum_light_oil)): ?>
                  <?php echo e(number_format($total->sum_light_oil)); ?>&nbsp;<?php echo app('translator')->get('system.unit.liter'); ?>
                  <?php $sumArray['light_oil'] = $sumArray['light_oil'] + intval($total->sum_light_oil); ?>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td class="text-end">
                <?php if(!empty($total->sum_adblue)): ?>
                  <?php echo e(number_format($total->sum_adblue)); ?>&nbsp;<?php echo app('translator')->get('system.unit.liter'); ?>
                  <?php $sumArray['adblue'] = $sumArray['adblue'] + intval($total->sum_adblue); ?>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td class="text-end">
                <?php if(!empty($total->sum_adblue_handy)): ?>
                  <?php echo e(number_format($total->sum_adblue_handy)); ?>&nbsp;<?php echo app('translator')->get('system.unit.ko'); ?>
                  <?php $sumArray['adblue_handy'] = $sumArray['adblue_handy'] + intval($total->sum_adblue_handy); ?>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr class="table-light">
              <td class="text-center fw-bold">
                合計
              </td>
              <td class="text-end fw-bold">
                <?php echo e(number_format($sumArray['light_oil'])); ?>&nbsp;<?php echo app('translator')->get('system.unit.liter'); ?>
              </td>
              <td class="text-end fw-bold">
                <?php echo e(number_format($sumArray['adblue'])); ?>&nbsp;<?php echo app('translator')->get('system.unit.liter'); ?>
              </td>
              <td class="text-end fw-bold">
                <?php echo e(number_format($sumArray['adblue_handy'])); ?>&nbsp;<?php echo app('translator')->get('system.unit.ko'); ?>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<script>
    window.addEventListener('load', function() {
        document.getElementById('search_user_id').addEventListener('change', function() {
          let requests = {
            user_id: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('search_start_at').addEventListener('change', function() {
          let requests = {
            start_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
    }, false);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/total/report/oil.blade.php ENDPATH**/ ?>