<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo app('translator')->get('db.pdf_billing'); ?> <?php echo app('translator')->get('system.title.index'); ?></h1>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <form action="<?php echo e(route('pdf.billing.output')); ?>" method="get">
    <?php echo csrf_field(); ?>
    <div class="row">
      <div class="d-none d-md-block col-12 col-md">
      </div>
      <div class="col col-md p-2 text-end">
        <button type="button" id="last-month" class="btn btn-dark ms-1"><span class="bi bi-caret-left-fill"></span></button>
        <button type="button" id="this-month" class="btn btn-dark ms-1">今月</button>
        <button type="button" id="next-month" class="btn btn-dark ms-1"><span class="bi bi-caret-right-fill"></span></button>
      </div>
      <div class="col-12 col-md p-2">
        <div class="input-group ">
          <span class="input-group-text">開始日</span>
          <input type="date" id="search_from_at" class="form-control" name="from_at" placeholder="" value="<?php echo e(old('from_at', date('Y-m-d', strtotime($params['from_at'])))); ?>">
        </div>
      </div>
      <div class="col-12 col-md p-2">
        <div class="input-group ">
          <span class="input-group-text">終了日</span>
          <input type="date" id="search_to_at" class="form-control" name="to_at" placeholder="" value="<?php echo e(old('to_at', date('Y-m-d', strtotime($params['to_at'])))); ?>">
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-hover text-nowrap">
            <thead>
              <tr>
                <th class="text-center tb-col-icon-button">No.</th>
                <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.details'); ?></th>
                <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_id'); ?></th>
                <th class="text-end">金額</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $report_waypoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_waypoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td class="text-center tb-col-icon-button"><?php echo e($report_waypoints->firstItem() + $loop->index); ?></td>
                <td class="text-center tb-col-icon-button">
                  <a href="/pdf/billing/<?php echo e($report_waypoint->billing_id); ?>/details?from_at=<?php echo e($params['from_at']); ?>&to_at=<?php echo e($params['to_at']); ?>" class="btn btn-xs btn-primary"><span class="bi bi-list-nested"></span></a>
                </td>
                <td class="text-start"><?php echo e($report_waypoint->billing->name); ?></td>
                <td class="text-end"><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->sum_total_price)); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <?php echo $__env->make('common/pagination', ['tables' => $report_waypoints], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="row justify-content-center mt-4 mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">
      </div>
    </div>
  </form>
</div>
<script>
    window.addEventListener('load', function() {
        document.getElementById('search_from_at').addEventListener('change', function() {
          let requests = {
            from_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('search_to_at').addEventListener('change', function() {
          let requests = {
            to_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('last-month').addEventListener('click', function() {
          let dt = new Date(<?php echo e(date('Y', strtotime($params['from_at']))); ?>, <?php echo e(date('n', strtotime($params['from_at'])) - 1); ?>, <?php echo e(date('j', strtotime($params['from_at']))); ?>);
          let requests = {
            from_at: new Date(dt.getFullYear(), dt.getMonth() - 1, 1)
              .toLocaleDateString("ja-JP", {
                year: "numeric",
                month: "2-digit",
                day: "2-digit",
              })
              .split("/")
              .join("-"),
            to_at: new Date(dt.getFullYear(), dt.getMonth(), 0)
              .toLocaleDateString("ja-JP", {
                year: "numeric",
                month: "2-digit",
                day: "2-digit",
              })
              .split("/")
              .join("-")
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('this-month').addEventListener('click', function() {
          let dt = new Date();
          let requests = {
            from_at: new Date(dt.getFullYear(), dt.getMonth(), 1)
              .toLocaleDateString("ja-JP", {
                year: "numeric",
                month: "2-digit",
                day: "2-digit",
              })
              .split("/")
              .join("-"),
            to_at: new Date(dt.getFullYear(), dt.getMonth() + 1, 0)
              .toLocaleDateString("ja-JP", {
                year: "numeric",
                month: "2-digit",
                day: "2-digit",
              })
              .split("/")
              .join("-")
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('next-month').addEventListener('click', function() {
          let dt = new Date(<?php echo e(date('Y', strtotime($params['from_at']))); ?>, <?php echo e(date('n', strtotime($params['from_at'])) - 1); ?>, <?php echo e(date('j', strtotime($params['from_at']))); ?>);
          let requests = {
            from_at: new Date(dt.getFullYear(), dt.getMonth() + 1, 1)
              .toLocaleDateString("ja-JP", {
                year: "numeric",
                month: "2-digit",
                day: "2-digit",
              })
              .split("/")
              .join("-"),
            to_at: new Date(dt.getFullYear(), dt.getMonth() + 2, 0)
              .toLocaleDateString("ja-JP", {
                year: "numeric",
                month: "2-digit",
                day: "2-digit",
              })
              .split("/")
              .join("-")
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);    }, false);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/pdf/billing/index.blade.php ENDPATH**/ ?>