<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('db.report_waypoint.quantity'); ?><?php echo app('translator')->get('system.title.total'); ?></h1>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-12 col-md">
    </div>
    <div class="col col-md p-2">
      <select id="search_user_id" class="form-select" name="user_id">
        <option value="all">すべて表示</option>
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($user->id); ?>" <?php if($params['user_id'] == $user->id): ?> selected  <?php endif; ?>><?php echo e($user->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    </div>
    <div class="col-12 col-md p-2">
      <input type="month" id="search_start_at" class="form-control" name="start_at" placeholder="" value="<?php echo e(old('start_at', date('Y-m', strtotime($params['start_at'])))); ?>">
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-start">日付</th>
              <th class="text-end"><?php echo e(config('const.UNITS.1')); ?></th>
              <th class="text-end"><?php echo e(config('const.UNITS.2')); ?></th>
              <th class="text-end"><?php echo e(config('const.UNITS.3')); ?></th>
              <th class="text-end"><?php echo e(config('const.UNITS.4')); ?></th>
              <th class="text-end"><?php echo e(config('const.UNITS.5')); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php
              $sumArray['unit_1'] = 0;
              $sumArray['unit_2'] = 0;
              $sumArray['unit_3'] = 0;
              $sumArray['unit_4'] = 0;
              $sumArray['unit_5'] = 0;
            ?>
            <?php $__currentLoopData = $totals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="text-start">
                <?php echo e(date('j日', strtotime($total->date))); ?>

              </td>
              <td class="text-end">
                <?php if(!empty($total->sum_quantity_unit_1)): ?>
                  <?php echo e(number_format($total->sum_quantity_unit_1)); ?>&nbsp;<?php echo e(config('const.UNITS.1')); ?>

                  <?php $sumArray['unit_1'] = $sumArray['unit_1'] + intval($total->sum_quantity_unit_1); ?>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td class="text-end">
                <?php if(!empty($total->sum_quantity_unit_2)): ?>
                  <?php echo e(number_format($total->sum_quantity_unit_2)); ?>&nbsp;<?php echo e(config('const.UNITS.2')); ?>

                  <?php $sumArray['unit_2'] = $sumArray['unit_2'] + intval($total->sum_quantity_unit_2); ?>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td class="text-end">
                <?php if(!empty($total->sum_quantity_unit_3)): ?>
                  <?php echo e(number_format($total->sum_quantity_unit_3)); ?>&nbsp;<?php echo e(config('const.UNITS.3')); ?>

                  <?php $sumArray['unit_3'] = $sumArray['unit_3'] + intval($total->sum_quantity_unit_3); ?>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td class="text-end">
                <?php if(!empty($total->sum_quantity_unit_4)): ?>
                  <?php echo e(number_format($total->sum_quantity_unit_4)); ?>&nbsp;<?php echo e(config('const.UNITS.4')); ?>

                  <?php $sumArray['unit_4'] = $sumArray['unit_4'] + intval($total->sum_quantity_unit_4); ?>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td class="text-end">
                <?php if(!empty($total->sum_quantity_unit_5)): ?>
                  <?php echo e(number_format($total->sum_quantity_unit_5)); ?>&nbsp;<?php echo e(config('const.UNITS.5')); ?>

                  <?php $sumArray['unit_5'] = $sumArray['unit_5'] + intval($total->sum_quantity_unit_5); ?>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr class="table-light">
              <td class="text-center fw-bold">
                合計
              </td>
              <td class="text-end fw-bold">
                <?php echo e(number_format($sumArray['unit_1'])); ?>&nbsp;<?php echo e(config('const.UNITS.1')); ?>

              </td>
              <td class="text-end fw-bold">
                <?php echo e(number_format($sumArray['unit_2'])); ?>&nbsp;<?php echo e(config('const.UNITS.2')); ?>

              </td>
              <td class="text-end fw-bold">
                <?php echo e(number_format($sumArray['unit_3'])); ?>&nbsp;<?php echo e(config('const.UNITS.3')); ?>

              </td>
              <td class="text-end fw-bold">
                <?php echo e(number_format($sumArray['unit_4'])); ?>&nbsp;<?php echo e(config('const.UNITS.4')); ?>

              </td>
              <td class="text-end fw-bold">
                <?php echo e(number_format($sumArray['unit_5'])); ?>&nbsp;<?php echo e(config('const.UNITS.5')); ?>

              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<script>
    window.addEventListener('load', function() {
        document.getElementById('search_user_id').addEventListener('change', function() {
          let requests = {
            user_id: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('search_start_at').addEventListener('change', function() {
          let requests = {
            start_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
    }, false);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/total/report/quantity.blade.php ENDPATH**/ ?>