<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      <h1 class="h2"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('system.title.show'); ?></h1>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('system.title.information'); ?></div>
        <div class="card-body">
          <div class="container-fluid p-0 m-0">
            <div class="row">
              <div class="col-12 col-md-6">
                <p><?php echo app('translator')->get('db.report.user_id'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e($report->user->name); ?></strong></p>
              </div>
              <div class="col-12 col-md-6">
                <p><?php echo app('translator')->get('db.report.car_id'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e($report->car->number); ?>（<?php echo app('translator')->get('db.report.alcohol_check-'.intval($report->alcohol_check)); ?>）</strong></p>
              </div>
              <div class="col-12 col-md-6">
                <p><?php echo app('translator')->get('db.report.start'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(date('Y年n月j日 G時i分', strtotime($report->start_at))); ?>（<?php echo e($report->start_point); ?>）</strong></p>
              </div>
              <div class="col-12 col-md-6">
                <p><?php echo app('translator')->get('db.report.end'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php if(!empty($report->end_at)): ?><?php echo e(date('Y年n月j日 G時i分', strtotime($report->end_at))); ?><?php endif; ?>（<?php echo e($report->end_point); ?>）</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><?php echo app('translator')->get('db.report.start_meter'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->start_meter)); ?>&nbsp;<?php echo app('translator')->get('system.unit.km'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><?php echo app('translator')->get('db.report.end_meter'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->end_meter)); ?>&nbsp;<?php echo app('translator')->get('system.unit.km'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><?php echo app('translator')->get('db.report.milage'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php if(!empty($report->end_meter)): ?><?php echo e(number_format($report->end_meter - $report->start_meter)); ?><?php else: ?><?php echo e(0); ?><?php endif; ?>&nbsp;<?php echo app('translator')->get('system.unit.km'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><?php echo app('translator')->get('db.report.light_oil'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->light_oil)); ?>&nbsp;<?php echo app('translator')->get('system.unit.liter'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><?php echo app('translator')->get('db.report.adblue'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->adblue)); ?>&nbsp;<?php echo app('translator')->get('system.unit.liter'); ?></strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><?php echo app('translator')->get('db.report.adblue_handy'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e(number_format($report->adblue_handy)); ?>&nbsp;<?php echo app('translator')->get('system.unit.ko'); ?></strong></p>
              </div>
              <div class="col-12 col-md-12">
                <p><?php echo app('translator')->get('db.report.note'); ?>&nbsp;:&nbsp;<br class="d-sm-none" /><strong><?php echo e($report->note); ?></strong></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-2">
    <div class="col">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2"><?php echo app('translator')->get('db.report_waypoints'); ?> <?php echo app('translator')->get('system.title.index'); ?></div>
        <div class="card-body pt-1 pb-2">
          <?php if($report->waypoints->count() > 0): ?>
          <div class="table-responsive">
            <table class="table table-hover text-nowrap">
              <thead>
                <tr>
                  <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_up'); ?><span class="sort_button ms-2" data-sort="take_up"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.address'); ?><span class="sort_button ms-2" data-sort="address"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
                  <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
                  <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.unit_price'); ?><span class="sort_button ms-2" data-sort="unit_price"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.type_id'); ?><span class="sort_button ms-2" data-sort="type_id"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_id'); ?><span class="sort_button ms-2" data-sort="billing_id"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_disposal_name'); ?><span class="sort_button ms-2" data-sort="billing_disposal_name"></span></th>
                  <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.highway_money'); ?><span class="sort_button ms-2" data-sort="highway_money"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.note'); ?><span class="sort_button ms-2" data-sort="note"></span></th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $report->waypoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_waypoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td class="text-start"><?php if(!empty($report_waypoint->emergency)): ?><span class="bi bi-info-circle-fill me-1 text-warning"></span><?php endif; ?><?php echo e($report_waypoint->take_up); ?></td>
                  <td class="text-start"><?php echo e($report_waypoint->take_down); ?></td>
                  <td class="text-start"><?php echo e($report_waypoint->address); ?></td>
                  <td class="text-start"><?php echo e($report_waypoint->item_name); ?></td>
                  <td class="text-end"><?php if(!empty($report_waypoint->quantity)): ?><?php echo e(number_format($report_waypoint->quantity, 2)); ?><?php if(!empty($report_waypoint->unit)): ?>&nbsp;<?php echo e(config('const.UNITS.'.$report_waypoint->unit)); ?><?php endif; ?> <?php endif; ?></td>
                  <td class="text-end"><?php if(!empty($report_waypoint->unit_price)): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->unit_price)); ?><?php endif; ?></td>
                  <td class="text-start"><?php echo e($report_waypoint->type->name); ?></td>
                  <td class="text-start"><?php if(!empty($report_waypoint->billing_id)): ?><?php echo e($report_waypoint->billing->name); ?><?php endif; ?></td>
                  <td class="text-start"><?php echo e($report_waypoint->billing_disposal_name); ?></td>
                  <td class="text-end"><?php if(!empty($report_waypoint->highway_money)): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->highway_money)); ?><?php if($report_waypoint->highway_money > 0 && !empty($report_waypoint->highway_payment)): ?>&nbsp;&#40;<?php echo e(config('const.PAYMENTS.'.$report_waypoint->highway_payment)); ?>&#41;<?php endif; ?> <?php endif; ?></td>
                  <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="<?php echo e($report_waypoint->note); ?>"><?php echo e(Str::limit($report_waypoint->note, 50)); ?></span></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-2">
    <div class="col">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2"><?php echo app('translator')->get('db.report_partners'); ?> <?php echo app('translator')->get('system.title.index'); ?></div>
        <div class="card-body pt-1 pb-2">
          <?php if($report->partners->count() > 0): ?>
          <div class="table-responsive">
            <table class="table table-hover text-nowrap">
              <thead>
                <tr>
                  <th class="text-start"><?php echo app('translator')->get('db.report_partner.partner_id'); ?><span class="sort_button ms-2" data-sort="partner_id"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_partner.company_name'); ?><span class="sort_button ms-2"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_partner.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_partner.car_number'); ?><span class="sort_button ms-2" data-sort="car_number"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_partner.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_partner.count'); ?><span class="sort_button ms-2" data-sort="count"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_partner.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $report->partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td class="text-start"><?php echo e($report_partner->partner->name); ?></td>
                  <td class="text-start"><?php echo e($report_partner->partner->company_name); ?></td>
                  <td class="text-start"><?php echo e($report_partner->quantity); ?><?php echo app('translator')->get('system.unit.dai'); ?></td>
                  <td class="text-start"><?php echo e($report_partner->car_number); ?></td>
                  <td class="text-start"><?php echo e($report_partner->item_name); ?></td>
                  <td class="text-start"><?php echo e($report_partner->count); ?></td>
                  <td class="text-start"><?php echo e($report_partner->take_down); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-2">
    <div class="col">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2"><?php echo app('translator')->get('db.report_rests'); ?> <?php echo app('translator')->get('system.title.index'); ?></div>
        <div class="card-body pt-1 pb-2">
          <?php if($report->rests->count() > 0): ?>
          <div class="table-responsive">
            <table class="table table-hover text-nowrap">
              <thead>
                <tr>
                  <th class="text-start"><?php echo app('translator')->get('db.report_rest.point'); ?><span class="sort_button ms-2" data-sort="point"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_rest.start_at'); ?><span class="sort_button ms-2" data-sort="start_at"></span></th>
                  <th class="text-start"><?php echo app('translator')->get('db.report_rest.end_at'); ?><span class="sort_button ms-2" data-sort="end_at"></span></th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $report->rests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_rest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td class="text-start"><?php echo e($report_rest->point); ?></td>
                  <td class="text-start"><?php if(!empty($report_rest->start_at)): ?><?php echo e(date('G時i分', strtotime($report_rest->start_at))); ?><?php endif; ?></td>
                  <td class="text-start"><?php if(!empty($report_rest->end_at)): ?><?php echo e(date('G時i分', strtotime($report_rest->end_at))); ?><?php endif; ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
      <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
  <div class="row text-center mb-4 mt-4">
    <div class="d-none d-md-block col-md-4">
    </div>
    <div class="col-12 col-md-4">
      <?php if(session()->has('checkpoint')): ?>
        <a href="<?php echo e(session()->get('checkpoint')); ?>" class="btn btn-outline-primary w-100 mb-2"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
        <?php else: ?>
        <a href="./" class="btn btn-outline-primary w-100 mb-2"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
      <?php endif; ?>
    </div>
  </div>
</div>
<script>
  let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });
</script>
<?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/report/detail.blade.php ENDPATH**/ ?>