<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('system.title.index'); ?></h1>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-12 col-md">
      <a href="/report/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span><?php echo app('translator')->get('system.command.create'); ?></a>
    </div>
    <div class="col col-md p-2">
      <select id="search_user_id" class="form-select" name="user_id">
        <option value="all">すべて表示</option>
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($user->id); ?>" <?php if($params['user_id'] == $user->id): ?> selected  <?php endif; ?>><?php echo e($user->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    </div>
    <div class="col-12 col-md p-2">
      <input type="month" id="search_start_at" class="form-control" name="start_at" placeholder="" value="<?php echo e(old('start_at', date('Y-m', strtotime($params['start_at'])))); ?>">
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th>
              <th class="text-start"><?php echo app('translator')->get('db.report.start_at'); ?>&nbsp;&#65374;&nbsp;<?php echo app('translator')->get('db.report.end_at'); ?><span class="sort_button ms-2" data-sort="start_at"></span></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('db.report_waypoints_short'); ?></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('db.report_partners_short'); ?></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('db.report_rests_short'); ?></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.show'); ?></th>
              <th class="text-start"><?php echo app('translator')->get('db.report.start_point'); ?><span class="sort_button ms-2" data-sort="start_point"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report.end_point'); ?><span class="sort_button ms-2" data-sort="end_point"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report.user_id'); ?><span class="sort_button ms-2" data-sort="user_id"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report.car_id'); ?><span class="sort_button ms-2" data-sort="car_id"></span></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.delete'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/report/<?php echo e($report->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-start">
                <span class="text-primary me-3 fw-bold"><?php echo e(date('j日', strtotime($report->start_at))); ?></span><?php echo e(date('G時i分', strtotime($report->start_at))); ?>

                &nbsp;&#65374;&nbsp;
                <?php if(!empty($report->end_at)): ?><?php if(date('Ymd', strtotime($report->start_at)) !== date('Ymd', strtotime($report->end_at))): ?>(<?php echo e(date('j日', strtotime($report->end_at))); ?>)&nbsp;<?php endif; ?><?php echo e(date('G時i分', strtotime($report->end_at))); ?><?php endif; ?>
              </td>
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/report/<?php echo e($report->id); ?>/waypoint" class="btn btn-xs btn-info"><span class="bi bi-geo-alt-fill"></span></a>
                  <?php if($report->waypoints->count() > 0): ?>
                  <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->waypoints->count()); ?></span>
                  <?php endif; ?>
                </div>
              </td>
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/report/<?php echo e($report->id); ?>/partner" class="btn btn-xs btn-info"><span class="bi bi-people-fill"></span></a>
                  <?php if($report->partners->count() > 0): ?>
                  <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->partners->count()); ?></span>
                  <?php endif; ?>
                </div>
              </td>
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/report/<?php echo e($report->id); ?>/rest" class="btn btn-xs btn-info"><span class="bi bi-tree-fill"></span></a>
                  <?php if($report->rests->count() > 0): ?>
                  <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->rests->count()); ?></span>
                  <?php endif; ?>
                </div>
              </td>
              <td class="text-center tb-col-icon-button">
                <a href="/report/<?php echo e($report->id); ?>" class="btn btn-xs btn-primary"><span class="bi bi-stickies-fill"></span></a>
              </td>
              <td class="text-start"><?php echo e($report->start_point); ?></td>
              <td class="text-start"><?php echo e($report->end_point); ?></td>
              <td class="text-start"><?php echo e($report->user->name); ?></td>
              <td class="text-start"><?php echo e($report->car->number); ?></td>
              <td class="text-center tb-col-icon-button">
                <form action="/report/<?php echo e($report->id); ?>" method="post">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common/pagination', ['tables' => $reports], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php echo $__env->make('common/script-sort', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('common/script-del_check', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    window.addEventListener('load', function() {
        document.getElementById('search_user_id').addEventListener('change', function() {
          let requests = {
            user_id: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('search_start_at').addEventListener('change', function() {
          let requests = {
            start_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
    }, false);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/report/index.blade.php ENDPATH**/ ?>