<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2"><?php if(Route::is('report.*')): ?> <?php echo app('translator')->get('db.reports'); ?> <?php echo app('translator')->get('db.report_waypoints'); ?> <?php endif; ?> <?php if(Route::is('work.*')): ?> <?php echo app('translator')->get('db.works'); ?> <?php endif; ?> <?php echo app('translator')->get('system.title.index'); ?></h1>
    </div>
  </div>
  <div class="row mb-3">
    <div class="col">
      <?php echo $__env->make('report/info', ['report' => $report], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
  </div>
  <?php echo $__env->make('common/error-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="row">
    <div class="col-12 col-md">
      <a href="./waypoint/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span><?php echo app('translator')->get('system.command.create'); ?></a>
      
    </div>
    <div class="col-12 col-md text-md-end">
    <?php if(Route::is('report.*')): ?>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/<?php echo e($report->id); ?>/waypoint" class="btn btn-xs btn-info"><span class="bi bi-geo-alt-fill"></span></a>
        <?php if($report->waypoints->count() > 0): ?>
        <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->waypoints->count()); ?></span>
        <?php endif; ?>
      </span>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/<?php echo e($report->id); ?>/partner" class="btn btn-xs btn-info"><span class="bi bi-people-fill"></span></a>
        <?php if($report->partners->count() > 0): ?>
        <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->partners->count()); ?></span>
        <?php endif; ?>
      </span>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/<?php echo e($report->id); ?>/rest" class="btn btn-xs btn-info"><span class="bi bi-tree-fill"></span></a>
        <?php if($report->rests->count() > 0): ?>
        <span class="badge rounded-pill bg-primary badge-from-btn"><?php echo e($report->rests->count()); ?></span>
        <?php endif; ?>
      </span>
    <?php endif; ?>
      <?php if(session()->has('checkpoint')): ?>
      <a href="<?php echo e(session()->get('checkpoint')); ?>" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
      <?php else: ?>
      <a href="../" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span><?php echo app('translator')->get('system.command.back'); ?></a>
      <?php endif; ?>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.edit'); ?></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_up'); ?><span class="sort_button ms-2" data-sort="take_up"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.take_down'); ?><span class="sort_button ms-2" data-sort="take_down"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.address'); ?><span class="sort_button ms-2" data-sort="address"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.item_name'); ?><span class="sort_button ms-2" data-sort="item_name"></span></th>
              <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.quantity'); ?><span class="sort_button ms-2" data-sort="quantity"></span></th>
              <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.unit_price'); ?><span class="sort_button ms-2" data-sort="unit_price"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.type_id'); ?><span class="sort_button ms-2" data-sort="type_id"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_id'); ?><span class="sort_button ms-2" data-sort="billing_id"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.billing_disposal_name'); ?><span class="sort_button ms-2" data-sort="billing_disposal_name"></span></th>
              <th class="text-end"><?php echo app('translator')->get('db.report_waypoint.highway_money'); ?><span class="sort_button ms-2" data-sort="highway_money"></span></th>
              <th class="text-start"><?php echo app('translator')->get('db.report_waypoint.note'); ?><span class="sort_button ms-2" data-sort="note"></span></th>
              <th class="text-center tb-col-icon-button"><?php echo app('translator')->get('system.command.delete'); ?></th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $report_waypoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report_waypoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="./waypoint/<?php echo e($report_waypoint->id); ?>/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-start"><?php if(!empty($report_waypoint->emergency)): ?><span class="bi bi-info-circle-fill me-1 text-warning"></span><?php endif; ?><?php echo e($report_waypoint->take_up); ?></td>
              <td class="text-start"><?php echo e($report_waypoint->take_down); ?></td>
              <td class="text-start"><?php echo e($report_waypoint->address); ?></td>
              <td class="text-start"><?php echo e($report_waypoint->item_name); ?></td>
              <td class="text-end"><?php if(!empty($report_waypoint->quantity)): ?><?php echo e(number_format($report_waypoint->quantity, 2)); ?><?php if(!empty($report_waypoint->unit)): ?>&nbsp;<?php echo e(config('const.UNITS.'.$report_waypoint->unit)); ?><?php endif; ?> <?php endif; ?></td>
              <td class="text-end"><?php if(!empty($report_waypoint->unit_price)): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->unit_price)); ?><?php endif; ?></td>
              <td class="text-start"><?php echo e($report_waypoint->type->name); ?></td>
              <td class="text-start"><?php if(!empty($report_waypoint->billing_id)): ?><?php echo e($report_waypoint->billing->name); ?><?php endif; ?></td>
              <td class="text-start"><?php echo e($report_waypoint->billing_disposal_name); ?></td>
              <td class="text-end"><?php if(!empty($report_waypoint->highway_money)): ?><?php echo app('translator')->get('system.unit.yen-mark'); ?><?php echo e(number_format($report_waypoint->highway_money)); ?><?php if($report_waypoint->highway_money > 0 && !empty($report_waypoint->highway_payment)): ?>&nbsp;&#40;<?php echo e(config('const.PAYMENTS.'.$report_waypoint->highway_payment)); ?>&#41;<?php endif; ?> <?php endif; ?></td>
              <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="<?php echo e($report_waypoint->note); ?>"><?php echo e(Str::limit($report_waypoint->note, 50)); ?></span></td>
              <td class="text-center tb-col-icon-button">
                <form action="./waypoint/<?php echo e($report_waypoint->id); ?>" method="post">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <?php echo $__env->make('common/pagination', ['tables' => $report_waypoints], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php echo $__env->make('common/script-del_check', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
  let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('common/main/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xs876501/miyagawa-t.com/laravel-project/miyagawa-transport/resources/views/report/waypoint/index.blade.php ENDPATH**/ ?>